'******************************************************************************
' IP routines
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile
'-------------------------------------------------------------------------------
' ENC28J60 Packet Filter
'-------------------------------------------------------------------------------
Sub Handle_enc28j60packet
   Call Enc28j60packetreceive                               'Copy packet into Buffer
   'Work out the packet
   If Eth_w_packettype = Eth_w_packettype_arp Then
#if Include_arp = 1
      Call Arp_packet_filter
#endif
   End If
   If Eth_w_packettype = Eth_w_packettype_ip Then
      If Ip_b_vers_and_length = Ip_standard_vers_and_length Then       'We handle only simple IP packets
         If Ip_b_destaddr(1) = My_b_ipaddr(1) Then          'Ip packet for us
            If Ip_b_destaddr(2) = My_b_ipaddr(2) Then
               If Ip_b_destaddr(3) = My_b_ipaddr(3) Then
                  If Ip_b_destaddr(4) = My_b_ipaddr(4) Then
#if Include_icmp = 1
                     If Ip_b_protocol = Ip_protocol_icmp Then       'Protocol:ICMP
                        Call Icmp_packet_filter
                     End If
#endif
#if Include_udp = 1
                     If Ip_b_protocol = Ip_protocol_udp Then       'Protocol:UDP
                        Call Udp_packet_filter
                     End If
#endif
#if Include_tcp = 1
                     If Ip_b_protocol = Ip_protocol_tcp Then       'Protocol:TCP
                        Call Tcp_packet_filter
                     End If
#endif
                  End If
               End If
            End If
         End If
         If Ip_b_destaddr(1) = 255 Then                     'Ip broadcast
            If Ip_b_destaddr(2) = 255 Then
               If Ip_b_destaddr(3) = 255 Then
                  If Ip_b_destaddr(4) = 255 Then
#if Include_udp = 1
                     If Ip_b_protocol = Ip_protocol_udp Then       'Protocol:UDP
                        Call Udp_packet_filter
                     End If
#endif
                  End If
               End If
            End If
         End If
      End If
   End If
End Sub

'-------------------------------------------------------------------------------
' IP Set Packet Length
'-------------------------------------------------------------------------------
Sub Ip_set_packet_length(byval Packlength As Word)
   Ip_w_packet_length = Packlength - Eth_headerlength
   Ip_w_packet_length = Reversed_word(ip_w_packet_length)
End Sub

'-------------------------------------------------------------------------------
' IP get Packet Length
'-------------------------------------------------------------------------------
Function Ip_get_packet_length() As Word
'Local Lw As Word
'   Lw = Reversed_word(ip_w_packet_length)
   Ip_get_packet_length = Reversed_word(ip_w_packet_length) + Eth_headerlength
End Function

'-------------------------------------------------------------------------------
' IP Get MAC address from IP address
'-------------------------------------------------------------------------------
'Function Get_mac_for_ip(ip_addr As Byte , Mac_addr As Byte) As Byte
'   If Ip_target_is_on_my_subnet(ip_addr) = 0 Then
'      Get_mac_for_ip = Arp_get_mac_from_cache(ip_addr , Eth_b_dest_mac(1))
'   Else
'      Get_mac_for_ip = Arp_get_mac_from_cache(ip_addr , Eth_b_dest_mac(1))
'   End If
'End Function


'-------------------------------------------------------------------------------
' IP Check for Subnet
'-------------------------------------------------------------------------------
Function Ip_target_is_on_my_subnet(ip_addr As Byte) As Byte
Local Laddr As Word
Local Lb As Byte
Local Lres As Byte
   Lres = 0
   Laddr = Varptr(ip_addr) :
   Lb = Inp(laddr) And My_b_subnetmask(1)
   If Lb = My_b_subnet(1) Then
      Incr Laddr
      Lb = Inp(laddr) And My_b_subnetmask(2)
      If Lb = My_b_subnet(2) Then
         Incr Laddr
         Lb = Inp(laddr) And My_b_subnetmask(3)
         If Lb = My_b_subnet(3) Then
            Incr Laddr
            Lb = Inp(laddr) And My_b_subnetmask(4)
            If Lb = My_b_subnet(4) Then
               Lres = 1
            End If
         End If
      End If
   End If
   Ip_target_is_on_my_subnet = Lres
End Function

'-------------------------------------------------------------------------------
' IP Get next Identifier
'-------------------------------------------------------------------------------
Function Ip_get_next_identifier() As Word
   Ip_get_next_identifier = Rnd(&Hffff)
End Function

'-------------------------------------------------------------------------------
' IP Header Checksum
'-------------------------------------------------------------------------------
Sub Ip_header_checksum
   Ip_w_hdr_cksum = &H00                                    'Initial chksum must be 0 during calculation
   Ip_w_hdr_cksum = Tcpchecksum(ip_header_start , Ip_headerlength )
End Sub

'-------------------------------------------------------------------------------
' Dump Buffer
'-------------------------------------------------------------------------------
#if Debug_ip > 0
Sub Dump_buffer(t_buffer As Byte , Byval Count As Word)
Local I As Word
Local T_addr As Word
Local T_dec As String * 6
Local T_hex As String * 4
Local T_mod As Byte
Local T_hexdata As String * 49
Local T_chrdata As String * 16
Local T_byte As Byte

   Print "--------------------------------------------------------------------"
   Print "  Data (" ; Count ; " Bytes)"
   Print "--------------------------------------------------------------------"

   T_addr = Varptr(t_buffer)
   Print "Dec   Hex   Data"
   I = 0
   T_hexdata = ""
   T_chrdata = ""
   Do
      T_mod = I Mod 16
      If T_mod = 0 Then
         T_dec = Str(i)
         If I < 10 Then T_dec = "0" + T_dec                 ' padding
         If I < 100 Then T_dec = "0" + T_dec                ' padding
         If I < 1000 Then T_dec = "0" + T_dec               ' padding
         T_hex = Hex(i)
      End If
      If I >= Count Then
         T_hexdata = T_hexdata + "   "
         T_chrdata = T_chrdata + " "
      Else
'         T_addr = Varptr(t_buffer)
'         T_addr = T_addr + I
         T_byte = Inp(t_addr)
         T_hexdata = T_hexdata + Hex(t_byte)
         T_hexdata = T_hexdata + " "
         If T_byte < 32 Then
            T_chrdata = T_chrdata + "."
         Else
            T_chrdata = T_chrdata + Chr(t_byte)
         End If
         If T_mod = 7 Then T_hexdata = T_hexdata + " "
      End If
      If T_mod = 15 Then
         If I >= Count Then Exit Do
         Print T_dec ; "  " ; T_hex ; "  " ; T_hexdata ; " " ; T_chrdata
         T_hexdata = ""
         T_chrdata = ""
      End If
      Incr I
      Incr T_addr
   Loop
End Sub
#endif

'-------------------------------------------------------------------------------
' Dump Ethernet Header
'-------------------------------------------------------------------------------
#if Debug_ip > 0
Sub Eth_dump_header
    Print "--------------------------------------------------------------------"
    Print "  Ethernet Header (14 Bytes)                                        "
    Print "--------------------------------------------------------------------"
    Print " Dest. Mac: " ; : Call Print_mac(eth_b_dest_mac(1) , Crlf)
    Print "Source MAC: " ; : Call Print_mac(eth_b_src_mac(1) , Crlf)
    Print " Eth. Type: " ; : Call Print_word(eth_w_packettype , Crlf)
End Sub
#endif

'-------------------------------------------------------------------------------
' Dump IP Header
'-------------------------------------------------------------------------------
#if Debug_ip > 0
Sub Ip_dump_header
    Print "--------------------------------------------------------------------"
    Print "  IP Header (20 Bytes)                                              "
    Print "--------------------------------------------------------------------"
    Print "VersHdrLen: " ; : Call Print_byte(ip_b_vers_and_length , Crlf)
    Print "       TOS: " ; : Call Print_byte(ip_b_type_of_service , Crlf)
    Print "Pkt length: " ; : Call Print_word(ip_w_packet_length , Crlf)
    Print "Identifier: " ; : Call Print_word(ip_w_identifier , Crlf)
    Print "  Fragment: " ; : Call Print_word(ip_w_fragmentation , Crlf)
    Print "       TTL: " ; : Call Print_byte(ip_b_time_to_live , Crlf)
    Print "  Protocol: " ; : Call Print_byte(ip_b_protocol , Crlf)
    Print "Hdr Chksum: " ; : Call Print_word(ip_w_hdr_cksum , Crlf)
    Print " Source IP: " ; : Call Print_ip(ip_b_srcaddr(1) , Crlf)
    Print "   Dest IP: " ; : Call Print_ip(ip_b_destaddr(1) , Crlf)
End Sub
#endif
'
'-------------------------------------------------------------------------------
' IP Check whether packet is for me
'-------------------------------------------------------------------------------
Function Ip_packet_is_for_me() As Byte
Local Lres As Byte
   Lres = Nok
   If Ip_b_destaddr_l = My_b_ipaddr_l Then
      Lres = Ok
   End If
  Ip_packet_is_for_me = Lres
End Function


Sub Clear_buffer
  Local Li As Word
  For Li = 1 To Max_framelen
   Buffer(li) = 0
  Next Li
End Sub


Function Reversed_long(byval Lg As Long) As Long
   Local Lw As Word
   Local Lbl As Byte
   Local Lbh As Byte

   'load low word
   Lw = Lg
   Lbl = Low(lw)
   Lbh = High(lw)

   Reversed_long = Lbl
   Shift Reversed_long , Left , 8
   Reversed_long = Reversed_long + Lbh
   Shift Reversed_long , Left , 8
   'load high word
   Lw = Highw(lg)
   Lbl = Low(lw)
   Lbh = High(lw)
   Reversed_long = Reversed_long + Lbl
   Shift Reversed_long , Left , 8
   Reversed_long = Reversed_long + Lbh
End Function


Function Is_equal_ip(ip1 As Byte , Ip2 As Byte) As Byte
Local Laddr1 As Word
Local Laddr2 As Word
Local Lres As Byte
   Lres = Nok
   Laddr1 = Varptr(ip1)
   Laddr2 = Varptr(ip2)
   If Inp(laddr1) = Inp(laddr2) Then
      Incr Laddr1 : Incr Laddr2
      If Inp(laddr1) = Inp(laddr2) Then
         Incr Laddr1 : Incr Laddr2
         If Inp(laddr1) = Inp(laddr2) Then
            Incr Laddr1 : Incr Laddr2
               If Inp(laddr1) = Inp(laddr2) Then
                  Lres = Ok
               End If
         End If
      End If
   End If
  Is_equal_ip = Lres
End Function